<?php

if (!defined('ABSPATH'))
    exit;

class wos_core {

    /**
     * The single instance
     * @var    object
     * @access  private
     * @since    1.0.0
     */
    private static $_instance = null;

    /**
     * Settings class object
     * @var     object
     * @access  public
     * @since   1.0.0
     */
    public $settings = null;

    /**
     * The version number.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $_version;

    /**
     * The token.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $_token;

    /**
     * The main plugin file.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $file;

    /**
     * The main plugin directory.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $dir;

    /**
     * The plugin assets directory.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $assets_dir;

    /**
     * The plugin assets URL.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $assets_url;

    /**
     * Suffix for Javascripts.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $templates_url;

    /**
     * Suffix for Javascripts.
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $script_suffix;

    /**
     * For menu instance
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $menu;

    /**
     * For template
     * @var     string
     * @access  public
     * @since   1.0.0
     */
    public $plugin_slug;

    /**
     * Constructor function.
     * @access  public
     * @since   1.0.0
     * @return  void
     */
    public function __construct($file = '', $version = '1.0.0') {
        $this->_version = $version;
        $this->_token = 'wos';
        $this->plugin_slug = 'wos';
        $this->chmodWrite = ( 0747 & ~ umask() );
        if (defined('FS_CHMOD_DIR')) {
            $this->chmodWrite = FS_CHMOD_DIR;
        }
        if ($this->chmodWrite == 0745) {
            $this->chmodWrite = 0755;
        }
        $this->file = $file;
        $this->dir = dirname($this->file);
        $this->assets_dir = trailingslashit($this->dir) . 'assets';
        $this->assets_url = esc_url(trailingslashit(plugins_url('/assets/', $this->file)));

        add_action('login_enqueue_scripts', array($this, 'login_enqueue_styles'), 10, 1);
        add_action('login_enqueue_scripts', array($this, 'login_enqueue_scripts'), 10, 1);
        add_action('plugins_loaded', array($this, 'init_localization'));
    }

    /*
     * Plugin init localization
     */
    public function init_localization() {
        $moFiles = scandir(trailingslashit($this->dir) . 'languages/');
        foreach ($moFiles as $moFile) {
            if (strlen($moFile) > 3 && substr($moFile, -3) == '.mo' && strpos($moFile, get_locale()) > -1) {
                load_textdomain('wos', trailingslashit($this->dir) . 'languages/' . $moFile);
            }
        }
    }

    public function login_enqueue_scripts($hook = '') {
        global $post;
        $settings = $this->getSettings();

        if ($settings->useAdminSkin && in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php'))) {
            wp_register_script($this->_token . '_login', esc_url($this->assets_url) . 'js/wos_osBackendLogin.min.js', array('jquery'), $this->_version);
            wp_enqueue_script($this->_token . '_login');
            $js_data[] = array(
                'useVideoBackground' => $settings->login_useVideoBackground,
                'backgroundVideo' => $settings->login_backgroundVideo);
            wp_localize_script($this->_token . '_login', 'wos_data', $js_data);
        }
    }

    public function login_enqueue_styles($hook = '') {
        global $post;
        $settings = $this->getSettings();
        if ($settings->useAdminSkin && in_array($GLOBALS['pagenow'], array('wp-login.php', 'wp-register.php'))) {
            wp_register_style($this->_token . '_login', esc_url($this->assets_url) . 'css/wos_osBackendLogin.min.css', array(), $this->_version);
            wp_enqueue_style($this->_token . '_login');

            wp_register_style($this->_token . '_customCss', esc_url($this->assets_url) . 'css/wos_customCss.css', array(), $this->_version);
            wp_enqueue_style($this->_token . '_customCss');
        }
    }

    /**
     * Main WOS_Core Instance
     *
     *
     * @since 1.0.0
     * @static
     * @see WOS_Core()
     * @return Main WOS_Core instance
     */
    public static function instance($file = '', $version = '1.0.0') {
        if (is_null(self::$_instance)) {
            self::$_instance = new self($file, $version);
        }
        return self::$_instance;
    }

// End instance()

    /**
     * Cloning is forbidden.
     *
     * @since 1.0.0
     */
    public function __clone() {
        
    }

// End __clone()

    /**
     * Unserializing instances of this class is forbidden.
     *
     * @since 1.0.0
     */
    public function __wakeup() {
    }

// End __wakeup()

    /**
     * Return settings.
     * @access  public
     * @since   1.0.0
     * @return  void
     */
    public function getSettings() {
        global $wpdb;
        $table_name = $wpdb->prefix . "wos_settings";
        $settings = $wpdb->get_results("SELECT * FROM $table_name WHERE id=1 LIMIT 1");
        return $settings[0];
    }

    // End getSettings()

    /**
     * Log the plugin version number.
     * @access  public
     * @since   1.0.0
     * @return  void
     */
    private function _log_version_number() {
        update_option($this->_token . '_version', $this->_version);
    }

}
